/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.goals.jobs;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import technology.rocketjump.undermount.entities.behaviour.HumanoidBehaviour;
import technology.rocketjump.undermount.entities.components.ProfessionsComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalException;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalFailedException;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.WorkOnJobGoal;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HaulingComponent;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.EntityMessage;
import technology.rocketjump.undermount.messaging.types.JobCompletedMessage;
import technology.rocketjump.undermount.rooms.ItemAllocation;
import technology.rocketjump.undermount.rooms.StockpileComponent;

public class PickUpItemGoal
extends Goal {
    private final ItemAllocation targetItemAllocation;
    private final TiledMap map;
    private final MessageDispatcher messageDispatcher;
    private final Job parentJob;
    private boolean itemPickedUp = false;

    public PickUpItemGoal(Entity parentEntity, WorkOnJobGoal workOnJobGoal, MessageDispatcher messageDispatcher, ItemAllocation itemAllocation, TiledMap map) {
        super(parentEntity);
        this.targetItemAllocation = itemAllocation;
        this.map = map;
        this.parentJob = workOnJobGoal.getAssignedJob();
        this.messageDispatcher = messageDispatcher;
    }

    @Override
    public void update(float deltaTimeSeconds) throws GoalException {
        MapTile currentTile = this.map.getTile(this.parentEntity.getLocationComponent().getWorldPosition());
        Entity entity = currentTile.getEntity(this.targetItemAllocation.getItemEntityId());
        if (entity == null) {
            this.messageDispatcher.dispatchMessage(null, 701, (Object)this.targetItemAllocation);
            throw new GoalFailedException("Target pickup item is no longer in target location");
        }
        int quantityToPick = this.targetItemAllocation.getQuantity();
        ItemEntityAttributes attributes = (ItemEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
        if (attributes.getQuantity() < quantityToPick) {
            this.messageDispatcher.dispatchMessage(null, 701, (Object)this.targetItemAllocation);
            throw new GoalFailedException("Target pickup item is not of sufficient quantity");
        }
        if (quantityToPick > attributes.getItemType().getMaxHauledAtOnce()) {
            int originalQuantityToPick = quantityToPick;
            quantityToPick = attributes.getItemType().getMaxHauledAtOnce();
            int remainingQuantityToPick = originalQuantityToPick - quantityToPick;
            this.targetItemAllocation.setQuantity(quantityToPick);
            attributes.setNumAllocated(attributes.getNumAllocated() - originalQuantityToPick);
            attributes.setNumAllocated(attributes.getNumAllocated() + quantityToPick);
        }
        Entity clonedItem = entity.clone(this.messageDispatcher, this.map);
        attributes.setNumAllocated(attributes.getNumAllocated() - quantityToPick);
        attributes.setQuantity(attributes.getQuantity() - quantityToPick);
        if (currentTile.getRoomTile() != null && currentTile.getRoomTile().getRoom().getStockpileComponent() != null) {
            StockpileComponent stockpileComponent = currentTile.getRoomTile().getRoom().getStockpileComponent();
            stockpileComponent.itemPickedUp(currentTile.getTilePosition(), quantityToPick, attributes);
        }
        ItemEntityAttributes cloneAttributes = (ItemEntityAttributes)clonedItem.getPhysicalEntityComponent().getAttributes();
        cloneAttributes.setQuantity(quantityToPick);
        cloneAttributes.setNumAllocated(quantityToPick);
        HaulingComponent haulingComponent = this.parentEntity.getOrCreateComponent(HaulingComponent.class);
        haulingComponent.setHauledItem(clonedItem, this.messageDispatcher);
        clonedItem.getLocationComponent().setWorldPosition(null, false);
        this.messageDispatcher.dispatchMessage(null, 700, (Object)clonedItem);
        HumanoidBehaviour parentBehaviour = (HumanoidBehaviour)this.parentEntity.getBehaviourComponent();
        this.messageDispatcher.dispatchMessage(null, 604, (Object)new JobCompletedMessage(this.parentJob, this.parentEntity.getComponent(ProfessionsComponent.class), this.parentEntity));
        if (attributes.getQuantity() <= 0) {
            this.messageDispatcher.dispatchMessage(null, 322, (Object)new EntityMessage(entity.getId()));
        } else {
            this.messageDispatcher.dispatchMessage(null, 324, (Object)entity);
        }
        this.itemPickedUp = true;
    }

    @Override
    public boolean isComplete() {
        return this.itemPickedUp;
    }
}

